/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.connmgr;

import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.connmgr.AddConnectConnectionInfo;
import com.ibm.hwmca.fw.connmgr.Authenticator;
import com.ibm.hwmca.fw.connmgr.CloseGroupConnectionInfo;
import com.ibm.hwmca.fw.connmgr.Connection;
import com.ibm.hwmca.fw.connmgr.ConnectionConstants;
import com.ibm.hwmca.fw.connmgr.ConnectionGroup;
import com.ibm.hwmca.fw.connmgr.ConnectionHandler;
import com.ibm.hwmca.fw.connmgr.ConnectionInfo;
import com.ibm.hwmca.fw.connmgr.ConnectionManager;
import com.ibm.hwmca.fw.connmgr.ConnectionReply;
import com.ibm.hwmca.fw.connmgr.ConnectionServer;
import com.ibm.hwmca.fw.connmgr.DisabledUseridException;
import com.ibm.hwmca.fw.connmgr.HMCAuthenticator;
import com.ibm.hwmca.fw.connmgr.HMCLocalAuthenticator;
import com.ibm.hwmca.fw.connmgr.InitialConnectionInfo;
import com.ibm.hwmca.fw.connmgr.InvalidPasswordException;
import com.ibm.hwmca.fw.connmgr.MultiConnectConnectionInfo;
import com.ibm.hwmca.fw.connmgr.MultiConnectionReply;
import com.ibm.hwmca.fw.connmgr.ServerConnection;
import com.ibm.hwmca.fw.connmgr.SingleConnectConnectionInfo;
import com.ibm.hwmca.fw.connmgr.VerifyConnectionInfo;
import com.ibm.hwmca.fw.connmgr.VerifyConnectionReply;
import com.ibm.hwmca.fw.fcs.impl.FcsConnectionHandler;
import com.ibm.hwmca.fw.logon.LogonValidation;
import com.ibm.hwmca.fw.system.ClientUserContext;
import com.ibm.hwmca.fw.system.CommonSystem;
import com.ibm.hwmca.fw.task.UserContext;
import com.ibm.hwmca.fw.tasklet.xport.monad.TaskletLoopbackConnectionHandler;
import com.ibm.hwmca.fw.tasklet.xport.stream.TaskletConnectionHandler;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.fw.util.UUID;
import com.ibm.hwmca.fw.util.UUIDFactory;
import com.ibm.hwmca.fw.util.WeakValueHashMap;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.Socket;
import java.util.HashMap;

public class ConnectionHandlerThread
extends Thread
implements ConnectionConstants {
    public static final String THIS_CLASS = "ConnectionHandlerThread";
    private static WeakValueHashMap HANDLERS = new WeakValueHashMap();
    private static HashMap PENDING = new HashMap();
    private Socket _socket;
    private ObjectInputStream _objectInputStream;
    private ObjectOutputStream _objectOutputStream;
    private String _userid;
    private UserContext _context;
    private ConnectionServer _server;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeHandler(UUID id) {
        WeakValueHashMap weakValueHashMap = HANDLERS;
        synchronized (weakValueHashMap) {
            HANDLERS.remove(id);
        }
    }

    public static UserContext getUserContext() {
        return UserContext.getCurrentUserContext();
    }

    public ConnectionHandlerThread(Socket clientSocket, ConnectionServer server) {
        super("Connection Handler");
        this._socket = clientSocket;
        this._server = server;
    }

    private String getUserName() {
        return this._userid;
    }

    private ConnectionHandler getConnectionHandler(String handlerName) throws Exception {
        ConnectionHandler handler = null;
        if (handlerName.equals("tasklet")) {
            handler = new TaskletConnectionHandler();
        } else if (handlerName.equals("fcs")) {
            handler = new FcsConnectionHandler();
        } else if (handlerName.equals("tasklet_LoopBack")) {
            handler = new TaskletLoopbackConnectionHandler();
        } else {
            throw new Exception("Failed to find connection handler for handler name:  " + handlerName);
        }
        return handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startHandler(String handlerName, Serializable parm, ConnectionGroup group) throws Exception {
        ConnectionHandler handler = this.getConnectionHandler(handlerName);
        WeakValueHashMap weakValueHashMap = HANDLERS;
        synchronized (weakValueHashMap) {
            HANDLERS.clearRefs();
            HANDLERS.put(group.getID(), handler);
        }
        this.sendReply(new MultiConnectionReply(this._context.getContextId(), group.getID()));
        if (this.getUserName().equals("logonuser")) {
            handler.handleUnAuthenticated(group, parm);
        } else {
            handler.handleAuthenticated(group, parm);
        }
    }

    private void sendReply(ConnectionReply reply) throws Exception {
        Trace.trace("HSSLCONF", "ConnectionHandlerThread.java, sendReply:  " + reply);
        this._objectOutputStream.reset();
        this._objectOutputStream.writeObject(reply);
        this._objectOutputStream.flush();
        Trace.trace("HSSLCONF", "<-- ConnectionHandlerThread.sendReply:  sent " + reply);
    }

    private boolean localConnection(Socket socket) {
        return this._server.getPort() == 9940 && CommonSystem.getCommonSystem().isUsingHTML();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        block58: {
            Trace.trace("HSSLCONF", "--> ConnectionHandlerThread.run:  for socket " + this._socket);
            InetAddress clientAddress = this._socket.getInetAddress();
            Authenticator authenticator = null;
            try {
                if (this.localConnection(this._socket)) {
                    Trace.trace("HSSLCONF", "ConnectionHandlerThread.java.authenticateClient:  using local authenticator");
                    authenticator = new HMCLocalAuthenticator(this._socket);
                } else {
                    if (this._server.getPort() == 9940 && CommonSystem.getCommonSystem().isUsingHTML()) {
                        throw new HException("An attempt was made to connect to the manager from non-local socket:  " + this._socket);
                    }
                    Trace.trace("HSSLCONF", "ConnectionHandlerThread.java.authenticateClient:  using ssl authenticator");
                    authenticator = new HMCAuthenticator(this._socket);
                }
                authenticator.authenticateClient(this._server.getGateKeeper(), this._server.getContextKeeper());
                this._context = authenticator.getContext();
                this._userid = authenticator.getUserName();
                if (this._context == null) {
                    Trace.trace("HSSLCOND", "ConnectionHandlerThread.run:  creating a new context for " + this._userid);
                    int contextType = this._server.getPort() == 9940 ? 1 : 0;
                    this._context = new UserContext(this._userid, clientAddress, contextType, UUIDFactory.generate(4), null);
                    if (!this._userid.equals("logonuser")) {
                        this._server.putContext(this._context);
                        Trace.trace("HSSLCOND", "ConnectionHandlerThread.run:  new context id is " + this._context.getContextId());
                        Trace.trace("HSSLCOND", "ConnectionHandlerThread.run:  at new id, stored context " + this._context);
                    }
                } else {
                    Trace.trace("HSSLCOND", "ConnectionHandlerThread.run:  found an existing context for " + this._userid);
                }
            }
            catch (InvalidPasswordException e) {
                Trace.trace("HSSLCOND", "<-- ConnectionHandlerThread.java.run:  ", e);
                return;
            }
            catch (IOException e) {
                Trace.trace("HSSLCONF", "<-- ConnectionHandlerThread.java.run:  ", e);
                ConnectionManager.logException(e, (short)2098);
                return;
            }
            catch (HException e) {
                Trace.trace("HSSLCONF", "<-- ConnectionHandlerThread.java.run:  ", e);
                ConnectionManager.logException(e);
                return;
            }
            Trace.trace("HSSLCONT", "ConnectionHandlerThread.java.run authenticated user " + this.getUserName() + ", and socket " + this._socket);
            this._context.attachToThread();
            Trace.trace("HSSLCOND", "ConnectionHandlerThread.run:  attached context to thread " + this._context);
            try {
                this._socket.setSoTimeout(30000);
                ServerConnection connection = new ServerConnection(this._socket, !this.getUserName().equals("logonuser"));
                this._objectOutputStream = new ObjectOutputStream(this._socket.getOutputStream());
                this._objectInputStream = new ObjectInputStream(this._socket.getInputStream());
                ConnectionInfo info = (ConnectionInfo)this._objectInputStream.readObject();
                Trace.trace("HSSLCONF", "ConnectionHandlerThread.java.run:  " + info + ", " + this._socket);
                this._socket.setSoTimeout(0);
                Connection[] connections = null;
                ConnectionGroup group = null;
                ConnectionReply reply = null;
                switch (info._type) {
                    case 5: {
                        Trace.trace("HSSLCOND", "ConnectionHandlerThread.run:  got initial request from " + this.getUserName());
                        InitialConnectionInfo ici = (InitialConnectionInfo)info;
                        ClientUserContext clientUserContext = ici._context;
                        Trace.trace("HSSLCOND", "ConnectionHandlerThread.run:  received client user context " + clientUserContext);
                        if (clientUserContext == null) {
                            Trace.trace("HSSLCOND", "ConnectionHandlerThread.run:  client user context is null, so locales, address, and timezone on server-side context are not changed");
                        } else {
                            this._context.setLocales(clientUserContext.getLocales());
                            this._context.setAddress(clientUserContext.getAddress());
                            this._context.setTimeZone(clientUserContext.getTimeZone());
                        }
                        Trace.trace("HSSLCOND", "ConnectionHandlerThread.run:  set locales, address, and timezone in server-side user context, address is " + this._context.getAddress());
                        reply = new ConnectionReply(this._context.getContextId());
                        this.sendReply(reply);
                        break;
                    }
                    case 4: {
                        VerifyConnectionInfo vci = (VerifyConnectionInfo)info;
                        int connectionStatus = 0;
                        if (this._server.getPort() != 9920 && !this.getUserName().equals("logonuser")) {
                            try {
                                LogonValidation.GATE_KEEPER.lookupPassword(this.getUserName());
                            }
                            catch (InvalidPasswordException e) {
                                connectionStatus = 2;
                            }
                            catch (DisabledUseridException e) {
                                connectionStatus = 1;
                            }
                        }
                        reply = new VerifyConnectionReply(this._context.getContextId(), connectionStatus);
                        this.sendReply(reply);
                        break;
                    }
                    case 3: {
                        CloseGroupConnectionInfo cginfo = (CloseGroupConnectionInfo)info;
                        if (cginfo._id != null) {
                            ConnectionHandlerThread.closeHandler(cginfo._id);
                        }
                        reply = new ConnectionReply(this._context.getContextId());
                        this.sendReply(reply);
                        break;
                    }
                    case 2: {
                        AddConnectConnectionInfo acinfo = (AddConnectConnectionInfo)info;
                        ConnectionHandler handler = null;
                        WeakValueHashMap weakValueHashMap = HANDLERS;
                        synchronized (weakValueHashMap) {
                            handler = (ConnectionHandler)HANDLERS.get(acinfo._id);
                        }
                        if (handler == null) {
                            throw new Exception("No handler for connection to group id:  " + acinfo._id);
                        }
                        reply = new ConnectionReply(this._context.getContextId());
                        this.sendReply(reply);
                        handler.handleNewConnection(connection, acinfo._parm);
                        break;
                    }
                    case 0: {
                        SingleConnectConnectionInfo sginfo = (SingleConnectConnectionInfo)info;
                        connections = new Connection[]{connection};
                        group = new ConnectionGroup(UUIDFactory.generate(4), connections);
                        this.startHandler(sginfo._handler, sginfo._parm, group);
                        break;
                    }
                    case 1: {
                        MultiConnectConnectionInfo mcinfo = (MultiConnectConnectionInfo)info;
                        PendingConnection pc = null;
                        try {
                            connections = new Connection[mcinfo._total];
                            if (mcinfo._id == null) {
                                mcinfo._id = UUIDFactory.generate(4);
                                pc = new PendingConnection(connection, mcinfo._handler, mcinfo._total, mcinfo._parm);
                                HashMap hashMap = PENDING;
                                synchronized (hashMap) {
                                    PENDING.put(mcinfo._id, pc);
                                }
                                reply = new MultiConnectionReply(this._context.getContextId(), mcinfo._id);
                                this.sendReply(reply);
                                break;
                            }
                            HashMap hashMap = PENDING;
                            synchronized (hashMap) {
                                pc = (PendingConnection)PENDING.get(mcinfo._id);
                            }
                            if (pc == null) {
                                throw new Exception("Failed to find pending connection for id:  " + mcinfo._id);
                            }
                            if (pc.getCount() != mcinfo._count) {
                                throw new Exception("Out of sequence connection for id:  " + mcinfo._id);
                            }
                            pc.add(connection);
                            if (pc.isComplete()) {
                                group = new ConnectionGroup(mcinfo._id, pc._connections);
                                this.startHandler(pc._handler, pc._parm, group);
                                HashMap hashMap2 = PENDING;
                                synchronized (hashMap2) {
                                    PENDING.remove(mcinfo._id);
                                    break;
                                }
                            }
                            HashMap hashMap3 = PENDING;
                            synchronized (hashMap3) {
                                PENDING.put(mcinfo._id, pc);
                            }
                            reply = new ConnectionReply(this._context.getContextId());
                            this.sendReply(reply);
                            break;
                        }
                        catch (Exception e) {
                            if (pc != null) {
                                pc.close();
                            }
                            HashMap hashMap = PENDING;
                            synchronized (hashMap) {
                                PENDING.remove(mcinfo._id);
                            }
                            throw e;
                        }
                    }
                }
                Object var26_40 = null;
            }
            catch (Throwable throwable) {
                Object var26_43 = null;
                Trace.trace("HSSLCONT", "<- ConnectionHandlerThread.java.run(" + this._socket + ")");
                throw throwable;
            }
            Trace.trace("HSSLCONT", "<- ConnectionHandlerThread.java.run(" + this._socket + ")");
            {
                break block58;
                catch (RuntimeException e) {
                    Trace.trace("HSSLCOND", "ConnectionHandlerThread.run:  caught a runtime exception:  ", e);
                    Trace.trace("HSSLCOND", "ConnectionHandlerThread.run:  just returning instead of rethrowing the exception ");
                    ConnectionManager.logException(e);
                    Object var26_41 = null;
                    Trace.trace("HSSLCONT", "<- ConnectionHandlerThread.java.run(" + this._socket + ")");
                    break block58;
                }
                catch (Exception e) {
                    Trace.trace("HSSLCONF", "ConnectionHandlerThread.java.run:  " + this._socket + ", " + e);
                    try {
                        this._socket.close();
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    Trace.trace("HSSLCONF", "ConnectionHandlerThread.java, run:  exception was " + e);
                    ConnectionManager.logException(e);
                    Object var26_42 = null;
                    Trace.trace("HSSLCONT", "<- ConnectionHandlerThread.java.run(" + this._socket + ")");
                }
            }
        }
    }

    private class PendingConnection {
        int _count;
        Connection[] _connections;
        Serializable _parm;
        String _handler;

        PendingConnection(Connection conn, String handler, int total, Serializable parm) {
            this._connections = new Connection[total];
            this._connections[0] = conn;
            this._count = 1;
            this._handler = handler;
            this._parm = parm;
        }

        void add(Connection c) {
            this._connections[this._count] = c;
            ++this._count;
        }

        boolean isComplete() {
            return this._count == this._connections.length;
        }

        int getCount() {
            return this._count;
        }

        void close() {
            int i = 0;
            while (i < this._count) {
                try {
                    this._connections[i].getSocket().close();
                }
                catch (Exception e) {
                    Trace.trace("HSSLCONF", "ConnectionHandlerThread.java.close:  failed to close socket " + this._connections[i].getSocket());
                }
                ++i;
            }
        }
    }
}

